#!/bin/sh

mkdir -p /media/bootupdate
if [ ! -f /media/usb/bootupdate.squashfs ]; then
	echo "bootupdate.squashfs was not found."
	exit 1
fi

if mount -t squashfs -o ro /media/usb/bootupdate.squashfs /media/bootupdate ; then
	echo "bootupdate.squashfs mounted successfully."
else
	echo "bootupdate.squashfs seems to be corrupt. Unable to update."
	exit 1
fi

if [ -e /mnt/usb/forcereset ] || [ ! -e /dev/mmcblk0p2 ] || [ ! -e /dev/mmcblk0p1 ]; then
	echo "Found an SD card with an inappropriate partition layout. Reformatting."

	if [ -e /dev/mmcblk0p1 ]; then
		dd if=/dev/zero of=/dev/mmcblk0p1 bs=1048576 count=1
	fi

	if [ -e /dev/mmcblk0p2 ]; then
		dd if=/dev/zero of=/dev/mmcblk0p2 bs=1048576 count=1
	fi

	(
		echo o       # Create a new empty DOS partition table
		echo n       # Add a new partition
		echo p       # Primary partition
		echo 1       # Partition number
		echo 8192    # First sector (8192 for eMMC)
		echo 270335  # Last sector (for a 128M partition)
		echo t       # Set the partition type
		echo c       # Set the partition type to FAT32 (LBA)
		echo n       # Add a new partition
		echo p       # Primary partition
		echo 2       # Partition number
		echo 270336  # First sector (directly following first partition)
		echo         # Last sector (use the default to cover the whole memory)
		echo w       # Write changes
	) | fdisk /dev/mmcblk0

	cd /sbin
	ln -s mke2fs mkfs.ext4
	cd /

	# Use the -F (force) option twice, since we really want to overwrite whatever was on the eMMC.
	/sbin/mkfs.ext4 -F -F /dev/mmcblk0p2
fi

mount -t ext4 -o rw /dev/mmcblk0p2 /mnt/emmc_root
mkdir -p /mnt/emmc_root/data/config
mkdir -p /mnt/emmc_root/apps
mkdir -p /mnt/emmc_root/updates

# The update script used for the web based update can be used here as well.
if [ -f /media/bootupdate/sympl_fusion_boot_update.sh ]; then
	echo "Applying root image..."
	cp /media/bootupdate/sympl_fusion_boot_update.sh /media
	chmod +x /media/sympl_fusion_boot_update.sh
	/media/sympl_fusion_boot_update.sh
fi
sync
umount /media/bootupdate

# Remove old applications and copy new ones.
echo "Removing old applications..."
rm -f /mnt/emmc_root/apps/*
rm -f /mnt/emmc_root/updates/*
echo "Copying new applications..."
cp /media/usb/update_*.squashfs /mnt/emmc_root/updates
sync

# Done.
umount /mnt/emmc_root
i2cset -y 0 0x60 0x05 0x00
i2cset -y 0 0x60 0x06 0x00
echo b > /proc/sysrq-trigger
